Object subclass: #ExtendedClipboardInterface
	instanceVariableNames: 'clipboard'
	classVariableNames: 'Current MacServicesProcess'
	poolDictionaries: ''
	category: 'Sophie-Clipboard'!

!ExtendedClipboardInterface methodsFor: 'as yet unclassified' stamp: 'JSM 5/6/2006 15:44'!
addClipboardData: data dataFormat: aFormat
	^ self primAddClipboardData: clipboard data: data dataFormat: aFormat.! !

!ExtendedClipboardInterface methodsFor: 'as yet unclassified' stamp: 'JSM 5/6/2006 15:37'!
clearClipboard
	^ self primClearClipboard: clipboard.! !

!ExtendedClipboardInterface methodsFor: 'as yet unclassified' stamp: 'JSM 5/6/2006 15:28'!
createClipboard
	^ self primCreateClipboard.! !

!ExtendedClipboardInterface methodsFor: 'as yet unclassified' stamp: 'JSM 5/6/2006 15:38'!
getClipboardFormat: formatNumber
	^ self primGetClipboardFormat: clipboard formatNumber: formatNumber.! !

!ExtendedClipboardInterface methodsFor: 'as yet unclassified' stamp: 'JSM 5/6/2006 15:35'!
initialize
	clipboard := self createClipboard.! !

!ExtendedClipboardInterface methodsFor: 'as yet unclassified' stamp: 'JSM 5/6/2006 16:32'!
primAddClipboardData: clipboard data: data dataFormat: aFormat

	<primitive:'ioAddClipboardData' module: 'ClipboardExtendedPlugin'>
	^ self primitiveFailed.! !

!ExtendedClipboardInterface methodsFor: 'as yet unclassified' stamp: 'JSM 5/6/2006 16:32'!
primClearClipboard: clipboard

	<primitive:'ioClearClipboard' module: 'ClipboardExtendedPlugin'>
	^ self primitiveFailed.
! !

!ExtendedClipboardInterface methodsFor: 'as yet unclassified' stamp: 'JSM 5/6/2006 18:53'!
primCreateClipboard
	<primitive:'ioCreateClipboard' module: 'ClipboardExtendedPlugin'>
	^ self primitiveFailed.
! !

!ExtendedClipboardInterface methodsFor: 'as yet unclassified' stamp: 'JSM 5/6/2006 16:33'!
primGetClipboardFormat: clipboard formatNumber: formatNumber

	<primitive:'ioGetClipboardFormat' module: 'ClipboardExtendedPlugin'>
	^ self primitiveFailed.
! !

!ExtendedClipboardInterface methodsFor: 'as yet unclassified' stamp: 'JSM 5/6/2006 16:33'!
primReadClipboardData: clipboard format: format

	<primitive:'ioReadClipboardData' module: 'ClipboardExtendedPlugin'>.
	^ self primitiveFailed.
! !

!ExtendedClipboardInterface methodsFor: 'as yet unclassified' stamp: 'JSM 5/6/2006 15:38'!
readClipboardData: format
	^ self primReadClipboardData: clipboard format: format.! !

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

ExtendedClipboardInterface class
	instanceVariableNames: ''!

!ExtendedClipboardInterface class methodsFor: 'as yet unclassified' stamp: 'JSM 5/6/2006 15:32'!
current
	Current ifNil: [Current := self new].
	^Current! !

!ExtendedClipboardInterface class methodsFor: 'as yet unclassified' stamp: 'JSM 5/6/2006 18:14'!
initialize
	"ExtendedClipboardInterface initialize"
	Current := nil.
	Smalltalk addToStartUpList: self after: nil.
	Smalltalk addToShutDownList: self after: nil.! !

!ExtendedClipboardInterface class methodsFor: 'as yet unclassified' stamp: 'JSM 5/6/2006 15:33'!
shutDown: quitting
! !

!ExtendedClipboardInterface class methodsFor: 'as yet unclassified' stamp: 'JSM 5/6/2006 15:33'!
startUp: resuming
	"The image is either being newly started (resuming is true), or it's just been snapshotted"

	Current := nil.
	self current.! !

ExtendedClipboardInterface initialize!